% M-member n-dimensional CT-swarm
% The agents have point mass dynamics 
% Sliding mode control algorithm is used to force 
% motion along the gradient of the artivicial potential
% The algorithm uses the positions of all the other
% members to update its position 
% by Veysel Gazi

clear all; close all;clc;

global M n nn nnn u0 gamma;
global m_u_bar m_o_bar f_bar J_bar epsilon;
global m_nominal f_unknown;
global a b c;
global beta0 alpha0;
global w;


M = 3;   % # of swarm members
n = 2; % # of dimensions of the state space
nn = 2*n; % dimension of the agent dynamics
nnn = 3*n;

flag=0;
% Set a random IC
% x0 = 30*rand(nn, M);   
% Set a random initial positions and zero speed
rand('seed',0)
%x0 = [2*rand(n, M) 1*rand(n, 1); zeros(n, M+1); zeros(n, M+1)];  
x0 = [0.01*rand(n, M)-1 0*zeros(n, 1); zeros(n, M+1); zeros(n, M+1)];  

m_u_bar = 0.5; % Lower bound on the mass
m_o_bar = 1.5; % Upper bound on the mass
m_nominal = 1.0; % Actual mass of the agents
f_bar = 1; % Upper bound on the additive disturbances
f_unknown = 1.0*ones(n,1); % The magnitude of the unknown part of the vehicle dynamics
epsilon = 1.0; % For finite time reaching
gamma = 10; % The constant for the smoothness of tanh

% Formation parameters
% a = 1;
% b = a/2;
% c = a/sqrt(3);
c=sqrt(3)/1;
a =sqrt(3)*c/3;
%b = 2/5;


w=0.1;

J_bar = 20*M; % Upper bound on the time derivative of the potential
%u0 = 10; % The gain of the sliding mode controller
u0 = (1/m_u_bar)*(m_o_bar*f_bar + J_bar + epsilon); % Controller gain
% Calculate the controller gain
%mxd = calculate_maxdist(x0(:,1:M),M);
%alpha0 = M*(a*mxd + b*sqrt(c/2)*exp(-1/2));
%beta0 = a + 2*b*exp(-3/2);
%J_bar = 2*M*beta0*alpha0;
%u0 = (1/m_u_bar)*(m_o_bar*f_bar + J_bar + epsilon);

t0 = 0.0;
tf = 50;
tspan = [t0 tf];
tspan = t0:(tf-t0)/100:tf;

myoptions = odeset('OutputFcn','odeplot');
[t, x] = ode23('test5_sim', tspan, x0, myoptions);

r=length(x);
x1=x(1:r,1);
y1=x(1:r,2);
x2=x(1:r,7);
y2=x(1:r,8);
x3=x(1:r,13);
y3=x(1:r,14);
xt=x(1:r,19);
yt=x(1:r,20);

% Potential Function  
J1t=(1/2)*(((x1-xt).^2+(y1-yt).^2)-a^2).^2;
J2t=(1/2)*(((x2-xt).^2+(y2-yt).^2)-a^2).^2;
J3t=(1/2)*(((x3-xt).^2+(y3-yt).^2)-a^2).^2;
J1a=(1/2)*(((x1-x2).^2+(y1-y2).^2)-c^2).^2+(((x1-x3).^2+(y1-y3).^2)-c^2).^2;
J2a=(1/2)*(((x2-x1).^2+(y2-y1).^2)-c^2).^2+(((x2-x3).^2+(y2-y3).^2)-c^2).^2;
J3a=(1/2)*(((x3-x1).^2+(y3-y1).^2)-c^2).^2+(((x3-x2).^2+(y3-y2).^2)-c^2).^2;

if flag==0
   J=J1t+J2t+J3t+w*(J1a+J2a+J3a)/2;
end

if flag==1
   % Potential function for the obstacle
   obj=[4 6 8 9];

   for ind=1:r     
           xo1=obj(1)-x1(ind);
           xo2=obj(2)-x1(ind);
           yo1=obj(3)-y1(ind);
           yo2=obj(4)-y1(ind);    
           J1o(ind)=abs(xo2.*log(((yo2.^2+xo2.^2).^0.5+yo2)./(((yo2.^2+xo2.^2).^0.5-yo2)))-xo2.*log(((yo1.^2+xo2.^2).^0.5+yo1)/(((yo1.^2+xo2.^2).^0.5-yo1)))...
                   -xo1.*log(((yo2.^2+xo1.^2).^0.5+yo2)/(((yo2.^2+xo1.^2).^0.5-yo2)))+xo1.*log(((yo1.^2+xo1.^2).^0.5+yo1)/(((yo1.^2+xo1.^2).^0.5-yo1))));
   end

   for ind=1:r     
           xo1=obj(1)-x2(ind);
           xo2=obj(2)-x2(ind);
           yo1=obj(3)-y2(ind);
           yo2=obj(4)-y2(ind);    
           J2o(ind)=abs(xo2.*log(((yo2.^2+xo2.^2).^0.5+yo2)./(((yo2.^2+xo2.^2).^0.5-yo2)))-xo2.*log(((yo1.^2+xo2.^2).^0.5+yo1)/(((yo1.^2+xo2.^2).^0.5-yo1)))...
           -xo1.*log(((yo2.^2+xo1.^2).^0.5+yo2)/(((yo2.^2+xo1.^2).^0.5-yo2)))+xo1.*log(((yo1.^2+xo1.^2).^0.5+yo1)/(((yo1.^2+xo1.^2).^0.5-yo1))));
   end

   for ind=1:r     
           xo1=obj(1)-x3(ind);
           xo2=obj(2)-x3(ind);
           yo1=obj(3)-y3(ind);
           yo2=obj(4)-y3(ind);    
           J3o(ind)=abs(xo2.*log(((yo2.^2+xo2.^2).^0.5+yo2)./(((yo2.^2+xo2.^2).^0.5-yo2)))-xo2.*log(((yo1.^2+xo2.^2).^0.5+yo1)/(((yo1.^2+xo2.^2).^0.5-yo1)))...
           -xo1.*log(((yo2.^2+xo1.^2).^0.5+yo2)/(((yo2.^2+xo1.^2).^0.5-yo2)))+xo1.*log(((yo1.^2+xo1.^2).^0.5+yo1)/(((yo1.^2+xo1.^2).^0.5-yo1))));
   end

   J=J1t+J2t+J3t+w*(J1a+J2a+J3a)/2+wo*(J1o+J2o+J3o).';
end

% plot simulation results
% souce seeking, formation control and obstacle avoidance
figure;
plot(x1(1), y1(1), 'o',...
     x2(1), y2(1), 'o',...
     x3(1), y3(1), 'o',...
     'LineWidth',2, 'MarkerEdgeColor','b',...
     'MarkerFaceColor','g',...
     'MarkerSize',12); 
hold on;
plot(xt(1,1), yt(1,1), 'g*',...
    'LineWidth',2 ,'MarkerSize',12); 
plot(x1,y1, '-','LineWidth',2); 
plot(x2,y2, '-','LineWidth',2); 
plot(x3,y3, '-','LineWidth',2); 
plot(xt,yt, 'g-','LineWidth',5); 
plot(xt(r), yt(r),'g*','LineWidth',2,'MarkerSize',12);
plot((x1+x2+x3)./3,(y1+y2+y3)./3,'r-.','LineWidth',3);  
plot(x1(r), y1(r), 'o',...
     x2(r), y2(r), 'o',...
     x3(r), y3(r), 'o',...
     'LineWidth',2, 'MarkerEdgeColor','b',...
     'MarkerFaceColor','g',...
     'MarkerSize',12); 
for i=1:8:r-8,
     plot([x1(i), x2(i)], [y1(i), y2(i)], 'r--','LineWidth',2);
     plot([x2(i), x3(i)], [y2(i), y3(i)], 'r--','LineWidth',2);
     plot([x3(i), x1(i)], [y3(i), y1(i)], 'r--','LineWidth',2);
     plot((x1(i)+x2(i)+x3(i))./3,(y1(i)+y2(i)+y3(i))./3,'p',...
         'MarkerEdgeColor','b','LineWidth',2,...
         'MarkerFaceColor','r','MarkerSize',12);
end;
plot([x1(r), x2(r)], [y1(r), y2(r)], 'r--','LineWidth',3);
plot([x2(r), x3(r)], [y2(r), y3(r)], 'r--','LineWidth',3);
plot([x3(r), x1(r)], [y3(r), y1(r)], 'r--','LineWidth',3);
hold off;
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
title('Swarm Trajectories','FontSize',18,'FontWeight','bold');
grid on

if flag==0
   saveas(gcf,'swarmpath_gradesc_double.eps','psc2');
end
if flag==1
   patch([4,6,6,4],[8,8,9,9],[1,0,0]);
   saveas(gcf,'swarmpath_gradesc_double_ob.eps','psc2');
   axis([2 6 4 10]);
   saveas(gcf,'swarmpathzoom_gradesc_double_ob.eps','psc2');
end
axis tight

% formation
figure;
plot(xt(1:r),yt(1:r),'g','LineWidth',3);  
hold on
plot((x1(1:r)+x2(1:r)+x3(1:r))./3,(y1(1:r)+y2(1:r)+y3(1:r))./3,'p','MarkerEdgeColor','b','LineWidth',2,...
                'MarkerFaceColor','r',...
                'MarkerSize',12);
plot(x1(r), y1(r), 'o',...
     x2(r), y2(r), 'o',...
     x3(r), y3(r), 'o',...
     'LineWidth',2, 'MarkerEdgeColor','b',...
     'MarkerFaceColor','g',...
     'MarkerSize',12); 
plot([x1(r), x2(r)], [y1(r), y2(r)], 'r--','LineWidth',3);
plot([x2(r), x3(r)], [y2(r), y3(r)], 'r--','LineWidth',3);
plot([x3(r), x1(r)], [y3(r), y1(r)], 'r--','LineWidth',3);
title('Center Trajectory','FontSize',18,'FontWeight','bold');
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
legend('Target Trajectory','Formation Center Trajectory');
grid on

% center movement
figure;
plot(xt(r-6:r),yt(r-6:r),'g','LineWidth',3);  
hold on
plot((x1(r-6:r)+x2(r-6:r)+x3(r-6:r))./3,(y1(r-6:r)+y2(r-6:r)+y3(r-6:r))./3,'p','MarkerEdgeColor','b','LineWidth',2,...
                'MarkerFaceColor','r',...
                'MarkerSize',12);
plot(x1(r), y1(r), 'o',...
     x2(r), y2(r), 'o',...
     x3(r), y3(r), 'o',...
     'LineWidth',2, 'MarkerEdgeColor','b',...
     'MarkerFaceColor','g',...
     'MarkerSize',12); 
plot([x1(r), x2(r)], [y1(r), y2(r)], 'r--','LineWidth',3);
plot([x2(r), x3(r)], [y2(r), y3(r)], 'r--','LineWidth',3);
plot([x3(r), x1(r)], [y3(r), y1(r)], 'r--','LineWidth',3);
title('Center Trajectory','FontSize',18,'FontWeight','bold');
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
legend('Target Trajectory','Formation Center Trajectory');
%axis([11 13.5 -1 1.5])
axis([11 13.5 -1.05 1.45])
grid on
if flag==0
   saveas(gcf,'centerpath_gradesc_double.eps','psc2');
end


% potential functions
figure,
subplot(1,3,1)
plot(t, J,'LineWidth',3);  
xlabel('t','FontSize',18,'FontWeight','bold');
title('J','FontSize',18,'FontWeight','bold');
axis tight
grid;

subplot(1,3,2)
plot(t, J1t,t,J2t,t,J3t,'LineWidth',3); 
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{at}','FontSize',18,'FontWeight','bold');
legend('J_{1t}','J_{2t}','J_{3t}');
axis tight
grid;

subplot(1,3,3)
plot(t, (J1a+J2a+J3a)/2,'LineWidth',3);  
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{aa}','FontSize',18,'FontWeight','bold');
grid;
axis tight

if flag==0
   saveas(gcf,'J_gradesc_double.eps','psc2');
end

% potential functions
figure,
subplot(1,4,1)
plot(t, J,'LineWidth',3);  
xlabel('t','FontSize',18,'FontWeight','bold');
title('J','FontSize',18,'FontWeight','bold');
axis tight
grid;

subplot(1,4,2)
plot(t, J1t,t,J2t,t,J3t,'LineWidth',3); 
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{at}','FontSize',18,'FontWeight','bold');
legend('J_{1t}','J_{2t}','J_{3t}');
axis tight
grid;

subplot(1,4,3)
plot(t, (J1a+J2a+J3a)/2,'LineWidth',3);  
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{aa}','FontSize',18,'FontWeight','bold');
grid;
axis tight


subplot(1,4,4)
plot(t, J1o,t,J2o,t,J3o,'LineWidth',3); 
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{ao}','FontSize',18,'FontWeight','bold');
grid;
legend('J_{1o}','J_{2o}','J_{3o}');
axis tight

if flag==1
   saveas(gcf,'J_gradesc_double_ob.eps','psc2');
end